# satellite name
#
# input GMT YYYYmmddHH(MM) nominal time (not true obs time)
# output MT1R/MTS2

import time

def satname(GMT):
    nomgmt = time.strptime(GMT[:10], '%Y%m%d%H')
    t = time.mktime(nomgmt) + 9*60*60
    if t < time.mktime((2009,2,17,13,0,0,0,0,0)):
        satname = 'MT1R'
    elif t <= time.mktime((2009,2,18,19,0,0,0,0,0)):
        satname = 'MTS2'
    elif t <= time.mktime((2009,11,11,23,0,0,0,0,0)):
        satname = 'MT1R'
    elif t <= time.mktime((2009,11,12,12,0,0,0,0,0)):
        satname = 'MTS2'
    elif t <= time.mktime((2009,11,16,10,0,0,0,0,0)):
        satname = 'MT1R'
    elif t <= time.mktime((2009,11,27,12,0,0,0,0,0)):
        satname = 'MTS2'
    elif t <= time.mktime((2010,7,1,11,0,0,0,0,0)):
        satname = 'MT1R'
    elif t <= time.mktime((2010,10,7,14,0,0,0,0,0)):
        satname = 'MTS2'
    elif t <= time.mktime((2010,12,22,11,0,0,0,0,0)):
        satname = 'MT1R'
    elif t <= time.mktime((2011,8,3,10,0,0,0,0,0)):
        satname = 'MTS2'
    elif t <= time.mktime((2011,8,16,10,0,0,0,0,0)):
        satname = 'MT1R'
    elif t <= time.mktime((2011,11,1,11,0,0,0,0,0)):
        satname = 'MTS2'
    elif t <= time.mktime((2011,12,26,11,0,0,0,0,0)):
        satname = 'MT1R'
    else:
        satname = 'MTS2'
    return satname

def satfulname(GMT):
    fn = {'MT1R': 'MTSAT-1R',
          'MTS2': 'MTSAT-2',
         }[satname(GMT)]
    return fn

if __name__ == '__main__':
    import sys
    if len(sys.argv) > 1:
        print satname(sys.argv[1])
    else:
        print satname('2010070112')
